import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { outlineDecorator } from '../../../_storybook';
import { json } from '../../../formatters';

import { TimeInput } from './TimeInput';

const TimeInputStory = () => {
   // hooks
   const [value, setValue] = useState(new Date('2018-04-08T10:05:00Z'));

   // handlers
   const updateValue = (e: SyntheticEvent | null, v: Date) => setValue(v);

   // render
   return (
      <>
         <TimeInput value={value} onChange={updateValue} />
         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('form_inputs/DateTimePicker', module)
   .addDecorator(outlineDecorator)
   .add('_TimeInput', () => <TimeInputStory />);
