import { TextInput } from '@yandex-cloud/uikit';
import getHours from 'date-fns/getHours';
import getMinutes from 'date-fns/getMinutes';
import getSeconds from 'date-fns/getSeconds';
import setHours from 'date-fns/setHours';
import setMinutes from 'date-fns/setMinutes';
import setSeconds from 'date-fns/setSeconds';
import * as React from 'react';

import { IValueProps } from '../../../_models';
import { leftPad } from '../../../helpers';
import { usePreventScrollForInputs } from '../../../react_hooks';

import styles from './TimeInput.module.css';

interface Props extends IValueProps<Date> {
   showSeconds?: boolean;
}

/**
 * Контрол для ввода времени
 *
 * Он чутка неудобный, доработаю позже.
 */
export const TimeInput = React.memo(({ value, onChange, showSeconds = false }: Props) => {
   const [hour, minute, second] = [getHours(value), getMinutes(value), getSeconds(value)];

   // handlers
   const updateHour = (h: string) => {
      const rawHour = parseInt(h, 10);
      if (rawHour >= 0 && rawHour <= 23) {
         onChange(null, setHours(value, rawHour));
      }
   };

   const updateMinutes = (m: string) => {
      const rawMinutes = parseInt(m, 10);
      if (rawMinutes >= 0 && rawMinutes <= 59) {
         onChange(null, setMinutes(value, rawMinutes));
      }
   };

   const updateSeconds = (s: string) => {
      const rawSeconds = parseInt(s, 10);
      if (rawSeconds >= 0 && rawSeconds <= 59) {
         onChange(null, setSeconds(value, rawSeconds));
      }
   };

   const { setInputRef: hRef } = usePreventScrollForInputs();
   const { setInputRef: mRef } = usePreventScrollForInputs();
   const { setInputRef: sRef } = usePreventScrollForInputs();

   // render
   const format = (n: number) => leftPad(n.toString(), 2, '0');

   return (
      <div className={styles.wrapper}>
         <TextInput
            type={'number'}
            className={styles.control}
            value={format(hour)}
            onUpdate={updateHour}
            controlRef={hRef}
         />
         <span className={styles.divider}>:</span>
         <TextInput
            type={'number'}
            className={styles.control}
            value={format(minute)}
            onUpdate={updateMinutes}
            controlRef={mRef}
         />
         {showSeconds ? (
            <>
               <span className={styles.divider}>:</span>
               <TextInput
                  type={'number'}
                  className={styles.control}
                  value={format(second)}
                  onUpdate={updateSeconds}
                  controlRef={sRef}
               />
            </>
         ) : null}
      </div>
   );
});

TimeInput.displayName = 'TimeInput';
