import getDate from 'date-fns/getDate';
import isWeekend from 'date-fns/isWeekend';

export class Day {
   public readonly day: number;

   public readonly isWeekend: boolean;

   public readonly key: string;

   constructor(public readonly value: Date) {
      this.key = value.toJSON();
      this.day = getDate(value);
      this.isWeekend = isWeekend(value);
   }
}
