import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { SyntheticEvent, useMemo, useState } from 'react';

import { formatNumber, json } from '../../formatters';
import { IListOption } from '../CheckboxList/models';

import { DropdownCheckboxList } from './DropdownCheckboxList';

const options: IListOption[] = [
   { value: 'xxx', name: 'XXX' },
   { value: 'yyy', name: 'YYY' },
   { name: 'ZZZ', value: 'zzz' },
   { value: 'z-index', name: 'Z-индекс' },
];
const longOptions: IListOption[] = [
   { value: 'xxx', name: 'XXX XXX XXX XXX XXX XXX XXX XXX XXX XXX XXX XXX XXX' },
   { value: 'yyy', name: 'YYY YYY YYY YYY YYY YYY YYY YYY YYY YYY YYY YYY YYY ' },
   { name: 'ZZZ', value: 'zzz zzz' },
];

const getLabel = (count: number): string => `Location: ${count ? formatNumber(count) : 'any'}`;

export const Regular = () => {
   const [value, setValue] = useState(new Set(['xxx']));

   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   return (
      <>
         <DropdownCheckboxList
            name={'fake_name'}
            options={options}
            value={value}
            getLabel={getLabel}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

export const AvoidJumping = () => {
   const lotsOfOption = useMemo(() => {
      const result: IListOption[] = [{ value: 'xxx', name: 'XXX' }];
      for (let i = 0; i < 100; i += 1) {
         result.push({ value: `xxx_${i}`, name: `XXX_${i}` });
      }

      return result;
   }, []);

   const [value, setValue] = useState(new Set(['xxx']));

   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   return (
      <>
         <div style={{ height: 500 }}>before</div>

         <DropdownCheckboxList
            name={'fake_name'}
            options={lotsOfOption}
            value={value}
            getLabel={getLabel}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>

         <div style={{ height: 2000 }}>after</div>
      </>
   );
};

export const LongPlaceholder = () => {
   const [value, setValue] = useState(new Set(['xxx']));

   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   return (
      <>
         <DropdownCheckboxList
            name={'fake_name'}
            options={longOptions}
            value={value}
            onChange={onChange}
            disabled={boolean('disabled', false)}
            multiple={boolean('multiple', true)}
            limitPopupWidth={boolean('limitPopupWidth', true)}
            placeholder={text('placeholder', 'Select option...')}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

export const SingleOptionSelect = () => {
   const [value, setValue] = useState(new Set(['xxx']));

   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   return (
      <>
         <DropdownCheckboxList
            name={'fake_name'}
            options={options}
            value={value}
            onChange={onChange}
            multiple={boolean('multiple', false)}
            placeholder={text('placeholder', 'Select option...')}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

export default {
   title: 'form_inputs/DropdownCheckboxList',
} as Meta;
