import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { formatNumber, json } from '../../formatters';
import { ITreeOption } from '../CheckboxTree/models';

import { DropdownCheckboxTree } from './DropdownCheckboxTree';

const options: ITreeOption[] = [
   { value: 'xxx', name: 'XXX' },
   { value: 'yyy', name: 'YYY' },
   {
      children: [
         { value: 'aaa', name: 'AAA' },
         { value: 'bbb', name: 'BBB' },
         { value: 'ccc', name: 'CCC' },
      ],
      name: 'ZZZ',
      value: 'zzz',
   },
];

const getLabel = (count: number): string => `Location: ${count ? formatNumber(count) : 'any'}`;

const DropdownCheckboxTreeStory = () => {
   const [value, setValue] = useState(new Set(['xxx', 'bbb']));

   const onChange = (e: SyntheticEvent, v: Set<string>) => setValue(v);

   return (
      <>
         <DropdownCheckboxTree options={options} value={value} getLabel={getLabel} onChange={onChange} />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('form_inputs/DropdownCheckboxTree', module).add('regular', () => <DropdownCheckboxTreeStory />);
