import * as React from 'react';
import { SyntheticEvent } from 'react';

import { Dropdown } from '../../small_components';
//
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { CheckboxTree } from '../CheckboxTree/CheckboxTree';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { ITreeOption } from '../CheckboxTree/models';

import classes from './DropdownCheckboxTree.module.css';

interface IProps {
   humanize?: boolean;
   options: ITreeOption[];
   value: Set<string>;

   getLabel(count: number): string;

   onChange(e: SyntheticEvent, v: Set<string>): void;
}

/**
 * Копия DropdownCheckboxList, только работает с деревьями
 */
export const DropdownCheckboxTree = React.memo(({ humanize = false, options, value, getLabel, onChange }: IProps) => (
   <Dropdown className={classes.tree} switcher={getLabel(value.size)}>
      <CheckboxTree options={options} onChange={onChange} value={value} humanize={humanize} />
   </Dropdown>
));

DropdownCheckboxTree.displayName = 'DropdownCheckboxTree';
