import React from 'react';

import { BaseInputProps, OptionalNumber, TIMES_IN_S } from '../../_models';
import { formatNumber } from '../../formatters';
import { RoundedInput, RoundMeasure } from '../RoundedInput/RoundedInput';

const measures: RoundMeasure[] = [
   { name: 's', multiplier: TIMES_IN_S.Second },
   { name: 'm', multiplier: TIMES_IN_S.Minute },
   { name: 'h', multiplier: TIMES_IN_S.Hour },
   { name: 'd', multiplier: TIMES_IN_S.Day },
   { name: 'w', multiplier: TIMES_IN_S.Week },
];

export const renderDetails = (v: number) => `${formatNumber(v)} s`;

export interface DurationInputProps extends BaseInputProps<OptionalNumber> {
   defaultMeasure?: string;
   useRenderDetails?: boolean;
}

export const DurationInput: React.FC<DurationInputProps> = React.memo(
   ({ useRenderDetails = true, defaultMeasure = 'h', ...props }) => (
      <RoundedInput
         defaultMeasure={defaultMeasure}
         fixedWidth={50}
         measures={measures}
         renderDetails={renderDetails}
         useRenderDetails={useRenderDetails}
         {...props}
      />
   ),
);

DurationInput.displayName = 'DurationInput';
