import { ComponentMeta, Story } from '@storybook/react';
import React, { useState } from 'react';

import { OptionalNumber } from '../../_models';
import { DevJson } from '../../small_components';

import { DurationMsInput, DurationMsInputProps } from './DurationMsInput';

const Template: Story<DurationMsInputProps> = props => {
   const [value, setValue] = useState<OptionalNumber>(props.value);

   return (
      <>
         <DurationMsInput {...props} name={'test'} value={value} onChange={setValue} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Empty = Template.bind({});
Empty.args = { value: null };

export const Zero = Template.bind({});
Zero.args = { value: 0 };

export const Milliseconds = Template.bind({});
Milliseconds.args = { value: 54 };

export const Seconds = Template.bind({});
Seconds.args = { value: 1000 * 54 };

export const Minutes = Template.bind({});
Minutes.args = { value: 1000 * 60 * 5 };

export const Hours = Template.bind({});
Hours.args = { value: 1000 * 3600 * 3 };

export const Days = Template.bind({});
Days.args = { value: 1000 * 3600 * 24 * 4 };

export const Weeks = Template.bind({});
Weeks.args = { value: 1000 * 3600 * 24 * 7 * 3 };

export const HugeButNotRounding = Template.bind({});
HugeButNotRounding.args = { value: 1000 * 3600 * 24 * 4 + 1000 * 3600 * 2 };

export const HugeButNotRounding2 = Template.bind({});
HugeButNotRounding2.args = { value: 1000 * 3600 * 24 * 4 + 1000 * 3600 * 2 + 1 };

export default {
   args: {
      disabled: false,
      readonly: false,
   },
   component: DurationMsInput,
   title: 'form_inputs/DurationMsInput',
} as ComponentMeta<typeof DurationMsInput>;
