import React from 'react';

import { BaseInputProps, OptionalNumber, TIMES_IN_MS } from '../../_models';
import { formatNumber } from '../../formatters';
import { RoundedInput, RoundMeasure } from '../RoundedInput/RoundedInput';

const measures: RoundMeasure[] = [
   { name: 'ms', multiplier: TIMES_IN_MS.Millisecond },
   { name: 's', multiplier: TIMES_IN_MS.Second },
   { name: 'm', multiplier: TIMES_IN_MS.Minute },
   { name: 'h', multiplier: TIMES_IN_MS.Hour },
   { name: 'd', multiplier: TIMES_IN_MS.Day },
   { name: 'w', multiplier: TIMES_IN_MS.Week },
];

export const renderDetails = (v: number) => `${formatNumber(v)} ms`;

export interface DurationMsInputProps extends BaseInputProps<OptionalNumber> {
   defaultMeasure?: string;
   useRenderDetails?: boolean;
}

export const DurationMsInput: React.FC<DurationMsInputProps> = React.memo(
   ({ useRenderDetails = true, defaultMeasure = 's', ...props }) => (
      <RoundedInput
         defaultMeasure={defaultMeasure}
         fixedWidth={75}
         measures={measures}
         renderDetails={renderDetails}
         useRenderDetails={useRenderDetails}
         {...props}
      />
   ),
);

DurationMsInput.displayName = 'DurationMsInput';
