import { ComponentMeta, Story } from '@storybook/react';
import { ControlGroupOption } from '@yandex-cloud/uikit';
import React, { useState } from 'react';

import { DevJson } from '../../small_components';

import { EnumSwitcher, EnumSwitcherProps } from './EnumSwitcher';

const options: ControlGroupOption[] = [
   {
      value: 'val1',
      content: (
         <>
            Value <b style={{ color: 'green' }}>#1</b>
         </>
      ),
   },
   { value: 'val2', content: 'Value #2' },
   { value: 'val3', content: 'Val3' },
];

type StoryProps = Omit<EnumSwitcherProps, 'value' | 'onChange' | 'name' | 'options'>;

const Template: Story<StoryProps> = props => {
   const [value, setValue] = useState(options[0].value);

   return (
      <>
         <EnumSwitcher options={options} name={'test'} value={value} onChange={setValue} {...props} />

         <DevJson summary={'value'} open={true}>
            {value}
         </DevJson>
      </>
   );
};

export const Default = Template.bind({});
Default.args = {};
Default.storyName = 'EnumSwitcher';

export default {
   component: EnumSwitcher,
   title: 'form_inputs/EnumSwitcher',
} as ComponentMeta<typeof EnumSwitcher>;
