import { ControlGroupOption, RadioButton, RadioButtonSize } from '@yandex-cloud/uikit';
import React, { useCallback } from 'react';

import { BaseInputProps, EMPTY_VALUE } from '../../_models';
import { classNames } from '../../formatters';

import classes from './EnumSwitcher.module.css';

function getReadonlyValue(value: string, options: ControlGroupOption[]) {
   const currentOption = options.find(o => o.value === value);

   return currentOption ? currentOption.content : value || EMPTY_VALUE;
}

export interface EnumSwitcherProps extends BaseInputProps<string> {
   options: ControlGroupOption[];
   readonlyClassName?: string;
   size?: RadioButtonSize;
}

export const EnumSwitcher: React.FC<EnumSwitcherProps> = React.memo(
   ({
      className,
      disabled = false,
      hasError,
      name,
      onBlur,
      onChange,
      options,
      qa,
      readonly = false,
      readonlyClassName,
      size = 'm',
      value,
   }) => {
      const handleUpdate = useCallback(
         (v: string) => {
            onChange(v);

            onBlur?.();
         },
         [onBlur, onChange],
      );

      if (readonly) {
         return (
            <div className={classNames(className, readonlyClassName)}>
               {getReadonlyValue(value, options)}
               <input type={'hidden'} name={name} value={value} data-qa={qa} />
            </div>
         );
      }

      return (
         <div className={className}>
            <RadioButton
               className={classNames(classes.control, { [classes.error]: hasError })}
               disabled={disabled}
               name={name}
               onUpdate={handleUpdate}
               options={options}
               size={size}
               value={value}
               qa={qa}
            />
         </div>
      );
   },
);

EnumSwitcher.displayName = 'EnumSwitcher';
