import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React, { useState } from 'react';

import { OptionalNumber } from '../../_models';
import { DevJson } from '../../small_components';

import { OptionalNumberInput } from './OptionalNumberInput';

export const Regular = () => {
   const [value, setValue] = useState<OptionalNumber>(null);

   return (
      <>
         <OptionalNumberInput
            disabled={boolean('disabled', false)}
            readonly={boolean('readonly', false)}
            value={value}
            onChange={setValue}
            name={'test'}
            hasError={boolean('hasError', false)}
         >
            Label for input
         </OptionalNumberInput>

         <DevJson open={true} summary={'value'}>
            {value}
         </DevJson>
      </>
   );
};

export default {
   title: 'form-inputs/OptionalNumberInput',
} as Meta;
