import { boolean, number, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import React, { ReactNode, useCallback, useState } from 'react';

import { OptionalNumber } from '../../_models';
import { formatNumber } from '../../formatters';
import { DevJson } from '../../small_components';

import { RoundedInput, RoundMeasure } from './RoundedInput';

const millyCores: RoundMeasure[] = [
   { name: 'VCPU (CPU / 1000)', multiplier: 1 },
   { name: 'CPU', multiplier: 1000 },
];

const Story = ({ initialValue }: { initialValue: OptionalNumber }) => {
   const [value, setValue] = useState(initialValue);

   const renderDetails = useCallback((v: number): ReactNode => `${formatNumber(v)} VCPU`, []);

   return (
      <>
         <RoundedInput
            defaultMeasure={'CPU'}
            disabled={boolean('disabled', false)}
            fixedWidth={number('fixedWidth', 100)}
            hasError={boolean('hasError', false)}
            measures={millyCores}
            name={'test'}
            onChange={setValue}
            placeholder={text('placeholder', '')}
            readonly={boolean('readonly', false)}
            readonlyClassName={text('readonlyClassName', '')}
            renderDetails={boolean('hasRenderDetails', true) ? renderDetails : undefined}
            useRenderDetails={boolean('useRenderDetails', true)}
            value={value}
         />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Cores = () => <Story initialValue={10000} />;

export const Zero = () => <Story initialValue={0} />;

export const Empty = () => <Story initialValue={undefined} />;

export const ExternalChange = (name = 'test') => {
   const [value, setValue] = useState<OptionalNumber>(0);

   const renderDetails = useCallback((v: number): ReactNode => `${formatNumber(v)} VCPU`, []);
   const values = [500, 1000, 1500, 10000, 15500];

   return (
      <>
         <RoundedInput
            defaultMeasure={'CPU'}
            measures={millyCores}
            name={name}
            value={value}
            onChange={setValue}
            renderDetails={renderDetails}
         />
         <RoundedInput
            defaultMeasure={'CPU'}
            measures={millyCores}
            name={name}
            value={value}
            onChange={setValue}
            renderDetails={renderDetails}
         />

         <div>
            {values.map(v => (
               <Button key={v} onClick={() => setValue(v)}>
                  Set {formatNumber(v)} vCPU
               </Button>
            ))}
         </div>

         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export default {
   title: 'form_inputs/RoundedInput',
} as Meta;
