import { RoundMeasure } from './RoundedInput';
import { getInitValues } from './utils';

describe('form_inputs|RoundedInput', () => {
   describe('CPU Cores example', () => {
      const millyCores: RoundMeasure[] = [
         { name: 'VCPU (CPU / 1000)', multiplier: 1 },
         { name: 'CPU', multiplier: 1000 },
      ];

      it('should return correct number1', () => {
         const [v, m] = getInitValues(5000, millyCores, millyCores[1]);

         expect(v).toBe(5);
         expect(m).toBe('CPU');
      });

      it('should return correct number2', () => {
         const [v, m] = getInitValues(5500, millyCores, millyCores[1]);

         expect(v).toBe(5500);
         expect(m).toBe('VCPU (CPU / 1000)');
      });
   });

   describe('Bytes example', () => {
      const bytesConfigs: RoundMeasure[] = [
         { name: 'Bytes', multiplier: 1 },
         { name: 'KB', multiplier: 1024 },
         { name: 'MB', multiplier: 1024 * 1024 },
         { name: 'GB', multiplier: 1024 * 1024 * 1024 },
      ];

      it('should return null', () => {
         expect(getInitValues(null, bytesConfigs, bytesConfigs[3])).toEqual([null, 'GB']);
      });

      it('should return Bytes', () => {
         expect(getInitValues(200, bytesConfigs, bytesConfigs[3])).toEqual([200, 'Bytes']);
      });

      it('should return KB', () => {
         expect(getInitValues(1024, bytesConfigs, bytesConfigs[3])).toEqual([1, 'KB']);
      });

      it('should return MB', () => {
         expect(getInitValues(1024 * 1024 * 3, bytesConfigs, bytesConfigs[3])).toEqual([3, 'MB']);
      });

      it('should return GB', () => {
         expect(getInitValues(1024 * 1024 * 1024 * 3, bytesConfigs, bytesConfigs[3])).toEqual([3, 'GB']);
      });

      it('should return KB if not round', () => {
         expect(getInitValues(1024 * 1024 * 3 + 200 * 1024, bytesConfigs, bytesConfigs[3])).toEqual([3272, 'KB']);
      });
   });
});
