import { OptionalNumber } from '../../_models';
import { sortHandler } from '../../helpers';

import { RoundMeasure } from './RoundedInput';

/**
 * Экспортируется только для тестов
 */
export function getInitValues(
   value: OptionalNumber,
   measures: RoundMeasure[],
   defaultMeasure: RoundMeasure,
): [OptionalNumber, string] {
   if (value === null || value === undefined || value === 0) {
      return [value, defaultMeasure.name];
   }

   const sortedMeasures = [...measures].sort((a, b) => sortHandler(b.multiplier, a.multiplier));

   for (const mConfig of sortedMeasures) {
      const rest = value % mConfig.multiplier;
      if (rest === 0) {
         return [value / mConfig.multiplier, mConfig.name];
      }
   }

   return [value, defaultMeasure.name];
}
