import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React, { useState } from 'react';

import { json } from '../../formatters';

import { SetValuesInput } from './SetValuesInput';

export const String = () => {
   const [value, setValue] = useState(new Set<string>());

   return (
      <>
         <SetValuesInput
            name={'test'}
            readonly={boolean('readonly', false)}
            hasError={boolean('hasError', false)}
            value={value}
            onChange={setValue as any}
            placeholder={'List input (split with comma and any space)'}
         />

         <SetValuesInput
            name={'test'}
            readonly={boolean('readonly', false)}
            hasError={boolean('hasError', false)}
            value={value}
            onChange={setValue as any}
            placeholder={'List input (split only by new lines)'}
            separator={/\n/}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

export const Numbers = () => {
   const [value, setValue] = useState(new Set<number>());

   return (
      <>
         <SetValuesInput
            name={'test'}
            type={'number'}
            value={value}
            onChange={setValue as any}
            placeholder={'List input (split with comma and any space)'}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

export default {
   title: 'form_inputs/SetValuesInput',
} as Meta;
