import { select } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React, { useState } from 'react';

import { DevJson } from '../../small_components';

import { TIME_ZONES, TimeZonePicker } from './TimeZonePicker';

export const Regular = () => {
   const [timeZoneData, setTimeZone] = useState(TIME_ZONES[1]);

   return (
      <>
         <TimeZonePicker
            timeZoneKey={timeZoneData.key}
            onChange={setTimeZone}
            displayMode={select('Display mode', ['MSK', 'UTC'], undefined)}
         />

         <DevJson summary={'value'} open={true}>
            {timeZoneData}
         </DevJson>
      </>
   );
};

export default {
   title: 'form_inputs/TimeZonePicker',
} as Meta;
