import { capitalize, deCapitalize } from './capitalize';

describe('formatters/capitalize', () => {
   it('capitalize', () => {
      expect(capitalize('word')).toBe('Word');
      expect(capitalize('WORD')).toBe('WORD');
   });

   it('deCapitalize', () => {
      expect(deCapitalize('Word')).toBe('word');
      expect(deCapitalize('WORD')).toBe('wORD');
   });

   it('old asserts', () => {
      expect(capitalize('xxx')).toBe('Xxx');
      expect(capitalize('xxx yyy zzz')).toBe('Xxx yyy zzz');
      expect(capitalize('русский')).toBe('Русский');
      expect(capitalize('_русский')).toBe('_русский');
   });
});
