import { classNames } from './classNames';

describe('classNames', () => {
   it('should join strings', () => {
      expect(classNames()).toBe('');

      expect(classNames('a')).toBe('a');

      expect(classNames('a', 'b')).toBe('a b');
   });

   it('should skip falsy values', () => {
      expect(classNames('a', undefined as any, null as any)).toBe('a');
   });

   it('should remove duplicates', () => {
      expect(classNames('a', 'b', 'c', 'a')).toBe('a b c');
   });

   it('should work with objects', () => {
      expect(classNames({ x: true, y: false, z: true })).toBe('x z');

      expect(classNames('a', 'b', { x: true, y: false, z: true })).toBe('a b x z');

      expect(classNames({ x: undefined as any, y: null as any, z: 1 as any }, 'a', 'b')).toBe('z a b');
   });
});
