/**
 * Утилита для формирования списка классов для компонентов.
 *
 * Принимает на вход произвольное число аргументов.
 * Каждой аргумент может являться либо строкой, либо объектом.
 * В результат попадают все строки, а также ключи объектов со значениями, приводимыми к true.
 *
 * Смотри тесты для примеров использования.
 */
import { isEmpty } from '../helpers';

export function classNames(...classes: (string | object | undefined)[]): string {
   const result = new Set<string>();

   for (const record of classes) {
      if (typeof record === 'string' && record.trim().length > 0) {
         result.add(record);
         continue;
      }

      if (typeof record === 'object' && !isEmpty(record)) {
         Object.keys(record)
            .filter(k => (record as any)[k])
            .forEach(k => result.add(k));
      }
   }

   return Array.from(result).join(' ');
}
