import { pascalCase } from './pascalCase';

type Variant = string | null | undefined;

export function createE2eSelector(explicitSelector: Variant, ...fallback: Variant[]) {
   if (explicitSelector) {
      return explicitSelector;
   }

   for (const variant of fallback) {
      if (variant) {
         return pascalCase(variant);
      }
   }

   return 'NoE2eSelector';
}
