import { forHuman, forHumanCapitalized } from './forHuman';

describe('forHuman', () => {
   it('forHuman simple', () => {
      expect(forHuman('xx')).toBe('xx');
      expect(forHuman('aBcdE')).toBe('a Bcd E');
      expect(forHuman('xx-yy')).toBe('xx yy');
      expect(forHuman('xx_yy')).toBe('xx yy');
   });

   it('forHuman with abbreviations', () => {
      expect(forHuman('dns-server')).toBe('DNS server');
      expect(forHuman('dns server')).toBe('DNS server');

      expect(forHuman('cpu_overheat')).toBe('CPU overheat');
      expect(forHuman('fs_check')).toBe('FS check');
      expect(forHuman('ssh-access')).toBe('SSH access');
      expect(forHuman('ssh access')).toBe('SSH access');
      expect(forHuman('it is ok')).toBe('it is OK');
   });

   it('forHumanCapitalized', () => {
      expect(forHumanCapitalized('xx')).toBe('Xx');
      expect(forHumanCapitalized('xx yy')).toBe('Xx yy');
   });

   it('forHumanCapitalized empty string', () => {
      expect(forHumanCapitalized('')).toBe('');
   });
});
