import { capitalize } from './capitalize';
import { splitToWords } from './splitToWords';

const ABBREVIATIONS = new Set([
   'bmc', // Base Board Management Controller
   'cpu', // Central Processor Unit
   'crc', // Cyclic redundancy check
   'dns', // Domain Name System
   'fs', // File System
   'gpu', // Graphic Processor Unit
   'ipmi', // Intelligent Platform Management Interface
   'mac', // Media Access Control (MAC-адрес)
   'mtn', // Multi-Tenant Network
   'ok', // OK
   'rtc', // Yandex: RunTime Cloud
   'rx', // Receive Data
   'sas', // Yandex: Дата-центр Сасово
   'ssh', // Secure SHell
   'tx', // Transmit Data
   'vlan', // Virtual Local Area Network
   'yp', // Yandex: Yandex Platform, YP
   'yt', // Yandex: YT - система распределённых вычислений Map-Reduce
]);

const REPLACE_MAP = new Map([
   ['macs', 'MACs'],
   ['walle', 'Wall-E'],
]);

export function forHuman(value: string): string {
   return splitToWords(value)
      .map(word => (ABBREVIATIONS.has(word) ? word.toUpperCase() : word))
      .map(word => (REPLACE_MAP.has(word) ? REPLACE_MAP.get(word) : word))
      .join(' ');
}

export function forHumanCapitalized(value: string): string {
   return capitalize(forHuman(value));
}
