import { formatDate } from './formatDate';

describe('formatDate', () => {
   it('should format without preset', () => {
      expect(formatDate(new Date('2018-11-13T00:55:34Z'))).toBe('13 Nov 2018, 03:55:34');
   });

   it('should format with long preset', () => {
      expect(formatDate(new Date('2018-11-05T07:18:23Z'), 'long')).toBe('5 Nov 2018, 10:18:23');
   });

   it('should format with short preset', () => {
      expect(formatDate(new Date('2018-11-13T23:00:00Z'), 'short')).toBe('14 Nov 2018');
   });

   it('should format with iso preset', () => {
      expect(formatDate(new Date('2018-11-13T23:00:00Z'), 'iso')).toBe('2018-11-14');
   });

   it('should format number value', () => {
      expect(formatDate(1622207107563, 'long')).toBe('28 May 2021, 16:05:07');
   });
});
