import format from 'date-fns/format';

type DateFormat = 'long' | 'short' | 'iso' | string;

export function formatDate(date: Date | number, preset: DateFormat = 'long'): string {
   let f: string;

   switch (preset) {
      case 'long':
         f = 'd MMM yyyy, HH:mm:ss';
         break;

      case 'short':
         f = 'd MMM yyyy';
         break;

      case 'iso':
         f = 'yyyy-MM-dd';
         break;

      default:
         f = preset;
         break;
   }

   return format(date, f);
}
