import { formatStringList } from './formatStringList';

describe('formatStringList', () => {
   it('should return empty string for no values', () => {
      expect(formatStringList()).toBe('');
   });

   it('should format for one value', () => {
      expect(formatStringList('one')).toBe('one');
   });

   it('should format for two values', () => {
      expect(formatStringList('one', 'two')).toBe('one and two');
   });

   it('should format for multiple values', () => {
      expect(formatStringList('one', 'two', 'three', 'four', 'five')).toBe('one, two, three, four and five');
   });
});
