export function formatStringList(...strings: string[]): string {
   if (strings.length === 0) {
      return '';
   }

   if (strings.length === 1) {
      return strings[0];
   }

   const first = strings[0];
   const middle = strings.slice(1, strings.length - 1);
   const last = strings[strings.length - 1];

   const parts = [first, middle.length > 0 ? ', ' : '', middle.join(', '), ' and ', last];

   return parts.join('');
}
