import { json, JSON_INDENT } from './json';

describe('json formatter', () => {
   const pureJson = (o: any) => JSON.stringify(o, null, JSON_INDENT);

   it('should convert sets', () => {
      expect(json(new Set([1, 2]))).toBe(pureJson([1, 2]));

      expect(
         json({
            s: new Set([1]),
         }),
      ).toBe(
         pureJson({
            s: [1],
         }),
      );
   });

   it('should converts RegExp', () => {
      expect(json(/xxx/)).toBe('"/xxx/"');
   });

   it('should convert empty map to object', () => {
      expect(json(new Map())).toBe(pureJson({}));
   });

   it('should convert maps with string keys', () => {
      expect(
         json(
            new Map([
               ['x', 2],
               ['y', 3],
            ]),
         ),
      ).toBe(pureJson({ x: 2, y: 3 }));
   });

   it('should convert maps with not string keys', () => {
      expect(
         json(
            new Map([
               [5, 2],
               [45, 3],
            ]),
         ),
      ).toBe(
         pureJson([
            [5, 2],
            [45, 3],
         ]),
      );
   });

   it('should convert BigInt', () => {
      const bigintObject = { value: BigInt('161584479958364845665477778454666') };

      expect(json(bigintObject, 0)).toBe('{"value":161584479958364845665477778454666}');
   });
});
