export const JSON_INDENT = 2;

function isString<T>(v: T): boolean {
   return typeof v === 'string';
}

function fromPairs<V>(pairs: [string, V][]) {
   return pairs.reduce((acc, [k, v]) => {
      acc[k] = v;

      return acc;
   }, {});
}

export function json(obj: any, indent: number = JSON_INDENT): string {
   let isNeedPatchBigint = false;

   const jsonString = JSON.stringify(
      obj,
      (key, value) => {
         if (value instanceof Set) {
            return Array.from(value);
         }

         if (value instanceof RegExp) {
            return value.toString();
         }

         if (value instanceof Map) {
            if (value.size === 0) {
               return value;
            }
            const entries = Array.from(value.entries());

            return isString(entries[0][0]) ? fromPairs(entries) : entries;
         }

         if (typeof value === 'bigint') {
            isNeedPatchBigint = true; // side effect
            return `BigInt(${value.toString()})`;
         }

         return value;
      },
      indent,
   );

   if (isNeedPatchBigint) {
      return jsonString.replace(/"BigInt\(([0-9]+)\)"/g, (_, digits) => digits);
   }

   return jsonString;
}
