import { plural } from './plural';

describe('plural', () => {
   it('should return singleForm for 1', () => {
      expect(plural(1, 'apple', 'apples')).toBe('apple');
   });

   it('should return pluralForm for 2', () => {
      expect(plural(2, 'apple', 'apples')).toBe('apples');
   });

   it('should return pluralForm for negative and zero', () => {
      expect(plural(0, 'apple', 'apples')).toBe('apples');
      expect(plural(-2, 'apple', 'apples')).toBe('apples');
      expect(plural(-1.2, 'apple', 'apples')).toBe('apples');
   });
});
