import { splitToWords } from './splitToWords';

describe('formatters/splitToWords', () => {
   it('by symbols', () => {
      expect(splitToWords('ENV_TYPE')).toEqual(['ENV', 'TYPE']);
      expect(splitToWords('env-Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env_Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env\\Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env|Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env.Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env&Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env=Type')).toEqual(['env', 'Type']);
      expect(splitToWords('env, Type   ')).toEqual(['env', 'Type']);
      expect(splitToWords('env Type')).toEqual(['env', 'Type']);
   });

   it('by cases', () => {
      expect(splitToWords('EnvType')).toEqual(['Env', 'Type']);
      expect(splitToWords('envType')).toEqual(['env', 'Type']);
      expect(splitToWords('PDFType')).toEqual(['PDF', 'Type']);
   });

   it('old asserts', () => {
      expect(splitToWords('vla1 #mtn #rtc')).toEqual(['vla1', '#mtn', '#rtc']);

      expect(splitToWords('x_y_z')).toEqual(['x', 'y', 'z']);

      expect(splitToWords('x _y-z')).toEqual(['x', 'y', 'z']);
   });
});
