import { timeDistance } from './timeDistance';

describe('timeDistance', () => {
   it('should render hours (positive)', () => {
      expect(timeDistance(new Date('2018-11-25T13:40:45Z'), new Date('2018-11-25T11:40:45Z'))).toBe('+ 2:00:00.000');
   });

   it('should render hours (negative)', () => {
      expect(timeDistance(new Date('2018-11-25T11:40:45Z'), new Date('2018-11-25T13:40:45Z'))).toBe('- 2:00:00.000');
   });

   it('should render minutes', () => {
      expect(timeDistance(new Date('2018-11-25T13:40:45Z'), new Date('2018-11-25T13:35:45Z'))).toBe('+ 0:05:00.000');
   });

   it('should render seconds', () => {
      expect(timeDistance(new Date('2018-11-25T13:40:45Z'), new Date('2018-11-25T13:40:24Z'))).toBe('+ 0:00:21.000');
   });

   it('should render milliseconds', () => {
      expect(timeDistance(new Date('2018-11-25T13:40:45.984Z'), new Date('2018-11-25T13:40:45.324Z'))).toBe(
         '+ 0:00:00.660',
      );

      expect(timeDistance(new Date('2018-11-25T13:40:45.200Z'), new Date('2018-11-25T13:40:45.300Z'))).toBe(
         '- 0:00:00.100',
      );
   });

   it('should render all (positive)', () => {
      expect(timeDistance(new Date('2018-11-25T13:40:45.984Z'), new Date('2018-11-22T23:15:11.324Z'))).toBe(
         '+ 62:25:34.660',
      );
   });

   it('should render all (negative)', () => {
      expect(timeDistance(new Date('2018-11-22T23:15:11.324Z'), new Date('2018-11-25T13:40:45.984Z'))).toBe(
         '- 62:25:34.660',
      );
   });
});
