import { leftPad, rightPad } from '../helpers';

const ONE_SECOND = 1000;
const ONE_MINUTE = 60 * ONE_SECOND;
const ONE_HOUR = 60 * ONE_MINUTE;

class Duration {
   private readonly hours: number;

   private readonly milliseconds: number;

   private readonly minutes: number;

   private readonly seconds: number;

   constructor(private ms: number) {
      const absDiffMs = Math.abs(ms);

      let acc = 0;

      this.hours = Math.floor(absDiffMs / ONE_HOUR);
      acc += this.hours * ONE_HOUR;

      this.minutes = Math.floor((absDiffMs - acc) / ONE_MINUTE);
      acc += this.minutes * ONE_MINUTE;

      this.seconds = Math.floor((absDiffMs - acc) / ONE_SECOND);
      acc += this.seconds * ONE_SECOND;

      this.milliseconds = absDiffMs - acc;
   }

   public toString(): string {
      const hours = this.hours.toString();
      const minutes = leftPad(this.minutes.toString(), 2, '0');
      const seconds = leftPad(this.seconds.toString(), 2, '0');
      const ms = rightPad(this.milliseconds.toString(), 3, '0');

      const sign = `${this.ms >= 0 ? '+' : '-'}`;

      return `${sign} ${hours}:${minutes}:${seconds}.${ms}`;
   }
}

export function timeDistance(end: Date, start: Date): string {
   const diffMs = end.getTime() - start.getTime();
   const duration = new Duration(diffMs);

   return duration.toString();
}
