import React, { ReactNode } from 'react';

import { classNames } from '../../formatters';
import { LabelHint } from '../../forms2';
import { Rows } from '../../small_components';
import { IFormField } from '../models';

import classes from './FieldLayout.module.css';

interface IProps {
   config: IFormField;
   customLabel?: ReactNode;
   error?: string | null;
   help?: string | null;
}

export const FieldLayout: React.FC<IProps> = React.memo(({ config, error, help, customLabel, children }) => {
   let message: JSX.Element | null = null;
   if (error) {
      message = (
         <div className={classes.error}>
            <Rows text={error} />
         </div>
      );
   } else if (help) {
      message = (
         <div className={classes.help}>
            <Rows text={help} />
         </div>
      );
   }

   const label = customLabel || config.label;

   return (
      <>
         <div
            className={classNames(classes.label, {
               [classes.labelError]: Boolean(error),
            })}
         >
            <span className={classes.labelText}>{label}</span>
            {label ? (
               <>
                  <span className={classes.required}>{config.required ? '*' : <>&#65279;</>}</span>
                  <LabelHint text={config.hint} />
               </>
            ) : null}
         </div>

         <div className={classes.input}>
            {children}
            {message}
         </div>
      </>
   );
});

FieldLayout.displayName = 'FieldLayout';
