import { Checkbox } from '@yandex-cloud/uikit';
import * as React from 'react';

import { classNames } from '../../formatters';
import { autobind } from '../../utils';
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import classes from './fields.module.css';

export class BooleanField extends React.PureComponent<IFieldProps<boolean>> {
   public render() {
      return (
         <FieldLayout config={this.props.config} help={this.props.help} error={this.props.error}>
            <Checkbox
               disabled={this.props.disabled || this.props.readonly}
               className={classNames({ [classes.error]: Boolean(this.props.error) })}
               checked={this.props.value}
               onUpdate={this.onChange}
            >
               {this.props.config.checkboxLabel}
            </Checkbox>
         </FieldLayout>
      );
   }

   @autobind
   private onChange(v: boolean) {
      this.props.onChange(null, v);
   }
}
