import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { useState } from 'react';

import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { BooleanSwitcherField } from './BooleanSwitcherField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState(false);

   // handlers
   const onChange = () => setValue(v => !v);

   // render
   return (
      <>
         <BooleanSwitcherField
            config={
               {
                  checkboxLabel: 'With admin rights',
                  label: '',
                  name: 'sudo',
                  type: FormFieldType.Boolean,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/BooleanSwitcher', module).add('regular', () => <FieldStory />);
