import { Switch } from '@yandex-cloud/uikit';
import * as React from 'react';

import { classNames } from '../../formatters';
import { autobind } from '../../utils';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import classes from './fields.module.css';

export class BooleanSwitcherField extends React.PureComponent<IFieldProps<boolean>> {
   public render() {
      return (
         <FieldLayout config={this.props.config} help={this.props.help} error={this.props.error}>
            <Switch
               disabled={this.props.disabled || this.props.readonly}
               className={classNames(classes.control, { [classes.error]: Boolean(this.props.error) })}
               name={this.props.config.name}
               checked={this.props.value}
               onChange={this.onChange}
            >
               {this.props.config.checkboxLabel}
            </Switch>
         </FieldLayout>
      );
   }

   @autobind
   private onChange(e: any) {
      this.props.onChange(e, !this.props.value);
   }
}
