import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { NullableDate } from '../../_models';
import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { DateField } from './DateField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState<NullableDate>(null);

   // handlers
   const onChange = (e: SyntheticEvent | null, v: NullableDate) => setValue(v);

   // render
   return (
      <>
         <DateField
            config={
               {
                  label: 'Date',
                  name: 'date',
                  placeholder: 'Enter timeout',
                  type: FormFieldType.Date,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value!}
            onChange={onChange}
         />
         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/Date', module).add('regular', () => <FieldStory />);
