import * as React from 'react';

import { EMPTY_VALUE, NullableDate } from '../../_models';
import { DateTimePicker } from '../../form_inputs';
import { classNames, formatDate } from '../../formatters';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import styles from './DateTimeField.module.css';
import classes from './fields.module.css';

export function DateTimeField(props: IFieldProps<NullableDate>) {
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         {props.readonly ? (
            props.value ? (
               formatDate(props.value, 'long')
            ) : (
               EMPTY_VALUE
            )
         ) : (
            <DateTimePicker
               cls={classNames(styles.control, { [classes.error]: Boolean(props.error) })}
               disabled={props.disabled}
               onChange={props.onChange}
               value={props.value}
               withTime={true}
            />
         )}
      </FieldLayout>
   );
}
