import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { EnumField } from './EnumField';

type Value = 'ready' | 'assigned' | 'processing' | 'failed';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState<Value>('ready');

   // handlers
   const onChange = (e: SyntheticEvent | null, v: Value) => setValue(v);

   // render
   return (
      <>
         <EnumField
            config={
               {
                  label: 'State',
                  name: 'state',
                  options: [
                     { title: 'Ready', value: 'ready' },
                     { title: 'Assigned', value: 'assigned' },
                     { title: 'Processing', value: 'processing' },
                     { title: 'Failed', value: 'failed' },
                  ],
                  type: FormFieldType.Enum,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/Enum', module).add('regular', () => <FieldStory />);
