import { ControlGroupOption } from '@yandex-cloud/uikit';
import * as React from 'react';

import { EMPTY_VALUE } from '../../_models';
import { EnumSwitcher } from '../../form_inputs';
import { classNames } from '../../formatters';
import { autobind } from '../../utils';
import { FieldLayout } from '../components/FieldLayout';
import { IEnumOption, IFieldProps } from '../models';

import classes from './fields.module.css';

export class EnumField extends React.PureComponent<IFieldProps<string>> {
   public render() {
      const options = (this.props.config.options ?? []).map(
         o =>
            ({
               value: o.value,
               content: o.title,
            } as ControlGroupOption),
      );

      return (
         <FieldLayout config={this.props.config} help={this.props.help} error={this.props.error}>
            {this.props.readonly ? (
               this.getTitle(this.props.config.options!, this.props.value) || EMPTY_VALUE
            ) : (
               <EnumSwitcher
                  className={classNames({ [classes.error]: Boolean(this.props.error) })}
                  disabled={this.props.disabled || this.props.readonly}
                  name={this.props.config.name}
                  onChange={this.onChange}
                  options={options}
                  value={this.props.value}
               />
            )}
         </FieldLayout>
      );
   }

   private getTitle(options: IEnumOption[], value: string) {
      const option = options.find(o => o.value === value);

      return option ? option.title : value;
   }

   @autobind
   private onChange(v: string) {
      this.props.onChange(null, v);
   }
}
