import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { HiddenField } from './HiddenField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState('ready');

   // handlers
   const onChange = (e: SyntheticEvent | null, v: string) => setValue(v);

   // render
   return (
      <>
         Это поле не имеет визуального отображения. Просто хранит значение для отправки его в API.
         <HiddenField
            config={
               {
                  label: 'Hidden',
                  name: 'hidden',
                  type: FormFieldType.Hidden,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            value={value}
            onChange={onChange}
         />
         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/Hidden', module).add('regular', () => <FieldStory />);
