import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { narrowDecorator } from '../../_storybook';
import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { NumberField } from './NumberField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState(27);

   // handlers
   const onChange = (e: SyntheticEvent | null, v: number) => setValue(v);

   // render
   return (
      <>
         <NumberField
            config={
               {
                  label: 'Age',
                  name: 'age',
                  type: FormFieldType.Number,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/Number', module)
   .addDecorator(narrowDecorator)
   .add('regular', () => <FieldStory />);
