import { TextInput } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback } from 'react';

import { EMPTY_VALUE } from '../../_models';
import { classNames } from '../../formatters';
import { usePreventScrollForInputs } from '../../react_hooks';
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import classes from './fields.module.css';

export const NumberField: React.FC<IFieldProps<number>> = props => {
   const { config, help, error, readonly, disabled, value, onChange } = props;

   const handleUpdate = useCallback(
      (v: string) => {
         onChange(null, parseInt(v, 10));
      },
      [onChange],
   );

   const { setInputRef } = usePreventScrollForInputs();

   return (
      <FieldLayout config={config} help={help} error={error}>
         {readonly ? (
            value !== undefined ? (
               value
            ) : (
               EMPTY_VALUE
            )
         ) : (
            <TextInput
               className={classNames({ [classes.error]: Boolean(error) })}
               controlRef={setInputRef}
               disabled={disabled}
               name={config.name}
               onUpdate={handleUpdate}
               placeholder={config.placeholder}
               type={'number'}
               value={value !== undefined ? value.toString(10) : undefined}
            />
         )}
      </FieldLayout>
   );
};
