import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { narrowDecorator } from '../../_storybook';
import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { NumberSetField } from './NumberSetField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState<Set<number>>(new Set());

   // handlers
   const onChange = (e: SyntheticEvent | null, v: Set<number>) => setValue(v);

   // render
   return (
      <>
         <NumberSetField
            config={
               {
                  label: 'List of host invs',
                  name: 'hosts',
                  type: FormFieldType.NumberSet,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/NumberSet', module)
   .addDecorator(narrowDecorator)
   .add('regular', () => <FieldStory />);
