import * as React from 'react';

import { SetValuesInput } from '../../form_inputs';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

export const NumberSetField: React.FC<IFieldProps<Set<number>>> = React.memo(
   ({ config, help, error, disabled, readonly, value: propValue, onChange }) => {
      // handlers
      const handleChange = (v: Set<number>) => onChange(null, v);

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            <SetValuesInput
               type={'number'}
               hasError={Boolean(error)}
               value={propValue}
               name={config.name}
               placeholder={config.placeholder}
               disabled={disabled}
               readonly={readonly}
               onChange={handleChange}
               separator={config.separator}
            />
         </FieldLayout>
      );
   },
);
