import { TextInput } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback } from 'react';

import { EMPTY_VALUE } from '../../_models';
import { classNames } from '../../formatters';
import { usePreventScrollForInputs } from '../../react_hooks';
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

import classes from './fields.module.css';

export const StringField: React.FC<IFieldProps<string>> = props => {
   const { config, help, error, readonly, disabled, value, onChange } = props;
   const handleUpdate = useCallback(
      (v: string) => {
         onChange(null, v);
      },
      [onChange],
   );

   const { setInputRef } = usePreventScrollForInputs();

   return (
      <FieldLayout config={config} help={help} error={error}>
         {readonly ? (
            value || EMPTY_VALUE
         ) : (
            <TextInput
               className={classNames({ [classes.error]: Boolean(error) })}
               controlRef={setInputRef}
               disabled={disabled}
               hasClear={true}
               name={config.name}
               onUpdate={handleUpdate}
               placeholder={config.placeholder}
               value={value}
            />
         )}
      </FieldLayout>
   );
};
