import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { StringSetField } from './StringSetField';

function FieldStory() {
   // hooks
   const [value, setValue] = useState<Set<string>>(new Set());

   // handlers
   const change = (e: SyntheticEvent | null, v: Set<string>) => setValue(v);

   // render
   return (
      <>
         <StringSetField
            config={
               {
                  component: StringSetField,
                  label: 'List of ids',
                  name: 'list',
                  placeholder: 'List input (split with comma and any space)',
                  type: FormFieldType.Custom,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value!}
            onChange={change}
         />

         <StringSetField
            config={
               {
                  component: StringSetField,
                  label: 'List of phrases',
                  name: 'list',
                  placeholder: 'List input (split only by new lines)',
                  separator: /\n/,
                  type: FormFieldType.Custom,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value!}
            onChange={change}
         />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('forms/field types/StringSet', module).add('regular', () => <FieldStory />);
