import * as React from 'react';

import { SetValuesInput } from '../../form_inputs';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FieldLayout } from '../components/FieldLayout';
import { IFieldProps } from '../models';

export const StringSetField: React.FC<IFieldProps<Set<string>>> = React.memo(
   ({ config, help, error, disabled, readonly, value: propValue, onChange }) => {
      // handlers
      const handleChange = (v: Set<string>) => onChange(null, v);

      // render
      return (
         <FieldLayout config={config} help={help} error={error}>
            <SetValuesInput
               disabled={disabled}
               hasError={Boolean(error)}
               name={config.name}
               onChange={handleChange}
               placeholder={config.placeholder}
               readonly={readonly}
               separator={config.separator}
               type={'string'}
               value={propValue}
            />
         </FieldLayout>
      );
   },
);
