import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { narrowDecorator } from '../../_storybook';
import { json } from '../../formatters';
import { FormFieldType, IFormField } from '../models';

import { TextField } from './TextField';

const FieldStory = () => {
   // hooks
   const [value, setValue] = useState('khoden\niperfilyev\nmertas');

   // handlers
   const onChange = (e: SyntheticEvent | null, v: string) => setValue(v);

   // render
   return (
      <>
         <TextField
            config={
               {
                  label: 'Frontend developers',
                  name: 'names',
                  type: FormFieldType.Text,
               } as IFormField<any>
            }
            readonly={boolean('readonly', false)}
            disabled={boolean('disabled', false)}
            error={text('error', '')}
            value={value}
            onChange={onChange}
         />

         <pre>{json(value)}</pre>
      </>
   );
};

storiesOf('forms/field types/Text', module)
   .addDecorator(narrowDecorator)
   .add('regular', () => <FieldStory />);
